//
//  Keychain.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import <sys/param.h>
#import "Access.h"
#import "Certificate.h"
#import "Identity.h"


@interface Keychain : NSCachedObject {
    SecKeychainRef keychain;
    int error;
}

+ (UInt32)keychainManagerVersion;
+ (void)setUserInteractionAllowed:(BOOL)allowed;
+ (BOOL)userInteractionAllowed;
+ (void)lockAll;

+ (Keychain*)keychainWithKeychainRef:(SecKeychainRef)keych;
+ (Keychain*)createNewKeychainAtPath:(NSString*)path withPassword:(NSString*)password;
+ (Keychain*)defaultKeychain;
+ (Keychain*)keychainAtPath:(NSString*)path;

- (Keychain*)initWithKeychainRef:(SecKeychainRef)keych;
- (Keychain*)initNewAtPath:(NSString*)path withPassword:(NSString*)password;
- (Keychain*)initFromDefault;
- (Keychain*)initFromPath:(NSString*)path;

- (NSString*)path;

- (void)makeDefault;

- (BOOL)isUnlocked;
- (BOOL)isReadOnly;
- (BOOL)isWritable;

- (void)setVersion:(UInt32)version;
- (UInt32)version;
- (void)setLockOnSleep:(BOOL)lockOnSleep;
- (BOOL)lockOnSleep;
- (void)setLockAfterInterval:(BOOL)lockAfterInterval;
- (BOOL)lockAfterInterval;
- (void)setInterval:(UInt32)interval;
- (UInt32)interval;

- (void)lock;
- (void)unlock;
- (void)unlockWithPassword:(NSString*)password;

- (void)addItem:(KeychainItem*)item;
//- (void)importCertificateBundle:(CertificateBundle*)bundle;
- (void)addCertificate:(Certificate*)cert;
- (void)addGenericPassword:(NSString*)password onService:(NSString*)service forAccount:(NSString*)account;
- (void)addInternetPassword:(NSString*)password onServer:(NSString*)server forAccount:(NSString*)account port:(UInt16)port path:(NSString*)path inSecurityDomain:(NSString*)domain protocol:(SecProtocolType)protocol auth:(SecAuthenticationType)authType;

- (NSString*)passwordForGenericService:(NSString*)service forAccount:(NSString*)account;
- (NSString*)passwordForInternetServer:(NSString*)server forAccount:(NSString*)account port:(UInt16)port path:(NSString*)path inSecurityDomain:(NSString*)domain protocol:(SecProtocolType)protocol auth:(SecAuthenticationType)authType;

- (KeychainItem*)genericService:(NSString*)service forAccount:(NSString*)account;
- (KeychainItem*)internetServer:(NSString*)server forAccount:(NSString*)account port:(UInt16)port path:(NSString*)path inSecurityDomain:(NSString*)domain protocol:(SecProtocolType)protocol auth:(SecAuthenticationType)authType;

- (NSArray*)identitiesForUse:(CSSM_KEYUSE)use;
- (NSArray*)identitiesForAnyUse;
- (NSArray*)identitiesForEncryption;
- (NSArray*)identitiesForDecryption;
- (NSArray*)identitiesForSigning;
- (NSArray*)identitiesForVerify;
- (NSArray*)identitiesForSignRecovery;
- (NSArray*)identitiesForVerifyRecovery;
- (NSArray*)identitiesForWrapping;
- (NSArray*)identitiesForUnwrapping;
- (NSArray*)identitiesForDeriving;

- (NSArray*)createAndAddKeyPairWithAlgorithm:(CSSM_ALGORITHMS)alg bitSize:(UInt32)size publicUse:(CSSM_KEYUSE)pubUse publicAttributes:(UInt32)pubAttr privateUse:(CSSM_KEYUSE)privUse privateAttributes:(UInt32)privAttr access:(Access*)acc;

- (void)setAccess:(Access*)access;
- (Access*)access;

- (void)deleteCompletely;

- (int)lastError;
- (SecKeychainRef)keychainRef;

@end
